/*

 GUI Script of the Sphere Community Game
 
 xx AAA 2007 - inital version, Vincent van Beveren
 
 */

Game.log.info('Initializing Spritesets...');


// define spriteset defaults
Game.spriteset = {

	error:false,
	cached:true,
	CACHE:Object(),
	LoadSpriteset:function(rss,cached){return (cached==false?  LoadSpriteset(rss): this.CACHE[rss]||(this.CACHE[rss]=LoadSpriteset(rss)) );},
	GetSpriteset:function(rss) {return rss? this.CACHE[rss]:this.spritebase;},
	SetSpriteset:function(rss,spriteset) {this.CACHE[rss]=spriteset; return this;},
	GetSpritebase:function() {return this.spritebase;}, //TODO: check,do we need clone() here?
	SetSpritebase:function(rss,cached){ if(typeof rss=='object') {this.spritebase=rss; return this}; this.spritebase= this.LoadSpriteset(rss,cached).clone();this.spritebasename=rss;return this;},
	spritebasename: "",
	spritebase:undefined,
	transparant:CreateColor(0,0,0, 0),
	success:function(){return !this.error},
	reset:function(){this.error=false;return this;},
	clearCache:function(){this.CACHE=new Object();return this;},
	
applyColorMatrix : function(mixcolormatrix) {
  var tsi=this.spritebase.images;
  var i=tsi.length-1;
  do {
        var surf1= tsi[i].createSurface();
        surf1.applyColorFX(0, 0, surf1.width, surf1.height,  mixcolormatrix);
        tsi[i] = surf1.createImage();
  }
  while(i--);
  return this;
},

cleantransparencies: function() {
  var tsi=this.spritebase.images;
  var i=tsi.length-1;
  do {
        var surf1= tsi[i].createSurface();
        surf1.applyColorFX(0, 0, surf1.width, surf1.height,  mixcolormatrix);
        surf1.setBlendMode(REPLACE);
        var y=surf1.height-1;
        var transparant=this.transparant;
        do{var x=surf1.width-1;
        do{//var color= surf1.getPixel(x, y);
                //if(!color.alpha)
                if(!surf1.getPixel(x, y).alpha)
                surf1.setPixel(x,y,transparant);
        }while(x--);}while(y--);

        tsi[i] = surf1.createImage();
  }
  while(i--);
  return this;
},

exists: function(savenamerss) {
                var FileName=savenamerss||this.spritebasename;
                var FileList=GetFileList("spritesets");
                var i=FileList.length-1;
                do
                        if (FileName == FileList[i]) return true;
                while(i--);
                return false;
},

saveAs: function(savenamerss,overwrite,cleantransparencies) {
  var FileName=savenamerss||this.spritebasename;
  if(!overwrite && this.exists(FileName)) return false;
  return this.save(FileName,cleantransparencies);
},

save: function(savenamerss,cleantransparencies) {
        var FileName=savenamerss||this.spritebasename;
        if(cleantransparencies)this.cleantransparencies();
        return this.spritebase.save(FileName);
},

LoadMixAndSet: function(baserss,mixrss){
	if(baserss)this.SetSpritebase(baserss);
	var Arr=new Array();
	for(var i in mixrss){
		var Zindex= this.IsZindex(mixrss[i].rss);
		LL.log("LoadMixAndSet mixrss="+i+" Z="+Zindex)
		Arr.push({prio:priorities[1], z:priorities[0]} )
	}
	Arr = this.ssort(Arr);
	//mixrss.sort()	//#TODO
},

GetMixAndSet: function(ss,mixrss){this.spritebase=ss;this.LoadMixAndSet(undefined,mixrss)},

underMix: function(mixrss, mixcolormatrix,fixtransparencies) {
        var spr1 = this.spritebase;
        this.spritebase= (typeof mixrss == "string")? this.LoadSpriteset(mixrss).clone(): mixrss;
        if(mixcolormatrix) this.applyColorMatrix(mixcolormatrix);
        return this.mix(spr1,undefined,fixtransparencies);
},

overMix: function(mixrss, mixcolormatrix, fixtransparencies) {
        var spr2 = (typeof mixrss == "string")? this.LoadSpriteset(mixrss): mixrss;
        return this.mix(spr2,mixcolormatrix,fixtransparencies);
},

multiMix: function(mixrss_obj){
	for (var i in mixrss_obj){
		this.overMix(mixrss_obj[i].rss, mixrss_obj[i].cm);
	}
},

mix: function(spr2, mixcolormatrix,fixtransparencies) {
  var tsi=this.spritebase.images;
        var ReFrame= new Array(tsi.length); // Remember which frames we've already done
        var tsd=this.spritebase.directions;
        var tsdl=tsd.length;
        for(var i1=0; i1<tsdl;++i1)
        {
                var i2 = 0;
                var sdl=spr2.directions.length;
                while (         (i2 < sdl) &&
                                !(spr2.directions[i2].name == tsd[i1].name) )
                ++i2;   //Search spr2's same direction
                if(i2>=sdl) continue; //mixrss doesnt have this direction
                var sdi2=spr2.directions[i2];
                if(sdi2.frames.length>=tsd[i1].frames.length)
                {
                        var j=tsd[i1].frames.length-1;
                        do
                        {
                                var tsdi1fji=tsd[i1].frames[j].index;
                                if(ReFrame[tsdi1fji]==1) continue;
                                ReFrame[tsdi1fji]=1; //Mark as done
                                var surf1= tsi[tsdi1fji].createSurface();
                                var surf2= spr2.images[sdi2.frames[j].index].createSurface();

                                if(typeof mixcolormatrix=="object")
                                        surf2.applyColorFX(0, 0, surf2.width, surf2.height,  mixcolormatrix);
                                surf1.blitSurface(surf2, 0, 0);
                                if(fixtransparencies){
                                        var transparant=CreateColor(0,0,0, 0);  //Almost transparent. (helmet stuff)
                                        surf1.setBlendMode(REPLACE);
                                        var y=surf1.height-1;
                                        do{var x=surf1.width-1;
                                        do{var color= surf2.getPixel(x, y);
                                        if(color.alpha == 1)
                                                surf1.setPixel(x,y,transparant);
                                        }while(x--);}while(y--);
                                }
                                tsi[tsdi1fji]=surf1.createImage();
                        }
                        while(j--);
                }
                else
                        this.error=true;
        }
        return this;
},

ApplyColorFXPerson: function(colormatrix,sprite) {
	this.spritebase = GetPersonSpriteset(sprite||GetInputPerson());
        this.applyColorMatrix(colormatrix);
        SetPersonSpriteset(sprite||GetInputPerson(),this.spritebase);
},

MixAndSwap: function(garb,colormatrix,fixtransparencies,sprite)
{
	this.spritebase = GetPersonSpriteset(sprite||GetInputPerson());
        this.overMix(garb, colormatrix,fixtransparencies);
        SetPersonSpriteset( sprite||GetInputPerson(),this.spritebase );
},

ColorMatrix_JS: function(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb){
 if(this instanceof ColorMatrix_JS==false) {
        return new ColorMatrix_JS(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb);
 }

 this.color={
        rn:rn, rr:rr, rg:rg, rb:rb,
        gn:gn, gr:gr, gg:gg, gb:gb,
        bn:bn, br:br, bg:bg, bb:bb
 };
 this.create= function(){
        with(this.color) {
                return CreateColorMatrix(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb)
        }
 };
},

ssort: function(a,b){
        var a_ = this.re.exec(a.rss);
        var b_ = this.re.exec(b.rss);
        return b_[1] - a_[1] +(b_[0] -a_[0])<<4;
},

IsZindex: function(name){
        return this.re.exec(name)[0];
},


}


// define any other functions/objects

Game.ColorMatrix ={
        "Swap_red_and_blue" : CreateColorMatrix(0, 0,0,255,  0, 0,255,0,  0, 255,0,0),
        "Rotate_colors" : CreateColorMatrix(0, 0,255,0,  0, 0,0,255,  0, 255,0,0),
        "grayscale" : CreateColorMatrix(0, 85,85,85,  0, 85,85,85,  0, 85,85,85),
        "Swap_green_and_red" : CreateColorMatrix(0, 0,255,0,  0, 255,0,0,  0, 0,0,255)
};

Game.spriteset.ssort.re=/\/(\-?\d)(\d)\./;
Game.spriteset.IsZindex.re=/\/(\-?\d)/;

